<?php
require_once 'config.php';

// Obtener todas las ventas
if ($_SERVER['REQUEST_METHOD'] === 'GET' && !isset($_GET['id']) && !isset($_GET['cliente_id'])) {
    try {
        $query = "SELECT v.*, c.nombre as nombre_cliente 
                  FROM ventas v 
                  JOIN clientes c ON v.cliente_id = c.id 
                  ORDER BY v.fecha DESC";
        $resultado = $conexion->query($query);
        
        if (!$resultado) {
            responder(['error' => 'Error al obtener las ventas: ' . $conexion->error], 500);
        }
        
        $ventas = [];
        while ($fila = $resultado->fetch_assoc()) {
            $ventas[] = $fila;
        }
        
        responder($ventas);
    } catch (Exception $e) {
        responder(['error' => 'Error al obtener las ventas: ' . $e->getMessage()], 500);
    }
}

// Obtener una venta específica
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['id'])) {
    try {
        $id = $conexion->real_escape_string($_GET['id']);
        $query = "SELECT v.*, c.nombre as nombre_cliente 
                  FROM ventas v 
                  JOIN clientes c ON v.cliente_id = c.id 
                  WHERE v.id = '$id'";
        $resultado = $conexion->query($query);
        
        if (!$resultado) {
            responder(['error' => 'Error al obtener la venta: ' . $conexion->error], 500);
        }
        
        $venta = $resultado->fetch_assoc();
        
        if (!$venta) {
            responder(['error' => 'Venta no encontrada'], 404);
        }
        
        responder($venta);
    } catch (Exception $e) {
        responder(['error' => 'Error al obtener la venta: ' . $e->getMessage()], 500);
    }
}

// Obtener ventas de un cliente específico
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['cliente_id'])) {
    try {
        $cliente_id = $conexion->real_escape_string($_GET['cliente_id']);
        $query = "SELECT * FROM ventas WHERE cliente_id = '$cliente_id' ORDER BY fecha DESC";
        $resultado = $conexion->query($query);
        
        if (!$resultado) {
            responder(['error' => 'Error al obtener las ventas del cliente: ' . $conexion->error], 500);
        }
        
        $ventas = [];
        while ($fila = $resultado->fetch_assoc()) {
            $ventas[] = $fila;
        }
        
        responder($ventas);
    } catch (Exception $e) {
        responder(['error' => 'Error al obtener las ventas del cliente: ' . $e->getMessage()], 500);
    }
}

// Crear una nueva venta
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Obtener datos del cuerpo de la solicitud
        $datos = json_decode(file_get_contents('php://input'), true);
        
        if (!$datos) {
            responder(['error' => 'Datos inválidos'], 400);
        }
        
        // Validar datos requeridos
        if (empty($datos['cliente_id']) || empty($datos['monto']) || empty($datos['descripcion'])) {
            responder(['error' => 'El cliente, monto y descripción son obligatorios'], 400);
        }
        
        // Preparar consulta
        $cliente_id = $conexion->real_escape_string($datos['cliente_id']);
        $monto = $conexion->real_escape_string($datos['monto']);
        $descripcion = $conexion->real_escape_string($datos['descripcion']);
        $fecha = isset($datos['fecha']) ? $conexion->real_escape_string($datos['fecha']) : date('Y-m-d');
        $notas = $conexion->real_escape_string($datos['notas'] ?? '');
        
        $query = "INSERT INTO ventas (cliente_id, monto, descripcion, fecha, notas, fecha_registro) 
                  VALUES ('$cliente_id', '$monto', '$descripcion', '$fecha', '$notas', NOW())";
        
        if (!$conexion->query($query)) {
            responder(['error' => 'Error al crear la venta: ' . $conexion->error], 500);
        }
        
        // Registrar interacción
        $venta_id = $conexion->insert_id;
        $tipo = 'venta';
        $query_interaccion = "INSERT INTO interacciones (cliente_id, tipo, descripcion, fecha) 
                              VALUES ('$cliente_id', '$tipo', 'Nueva venta: $descripcion', NOW())";
        $conexion->query($query_interaccion);
        
        responder([
            'id' => $venta_id,
            'mensaje' => 'Venta registrada correctamente'
        ], 201);
    } catch (Exception $e) {
        responder(['error' => 'Error al crear la venta: ' . $e->getMessage()], 500);
    }
}

// Actualizar una venta
if ($_SERVER['REQUEST_METHOD'] === 'PUT') {
    try {
        // Obtener datos del cuerpo de la solicitud
        $datos = json_decode(file_get_contents('php://input'), true);
        
        if (!$datos || !isset($datos['id'])) {
            responder(['error' => 'Datos inválidos o ID no proporcionado'], 400);
        }
        
        // Validar datos requeridos
        if (empty($datos['cliente_id']) || empty($datos['monto']) || empty($datos['descripcion'])) {
            responder(['error' => 'El cliente, monto y descripción son obligatorios'], 400);
        }
        
        // Preparar consulta
        $id = $conexion->real_escape_string($datos['id']);
        $cliente_id = $conexion->real_escape_string($datos['cliente_id']);
        $monto = $conexion->real_escape_string($datos['monto']);
        $descripcion = $conexion->real_escape_string($datos['descripcion']);
        $fecha = isset($datos['fecha']) ? $conexion->real_escape_string($datos['fecha']) : date('Y-m-d');
        $notas = $conexion->real_escape_string($datos['notas'] ?? '');
        
        $query = "UPDATE ventas 
                  SET cliente_id = '$cliente_id', 
                      monto = '$monto', 
                      descripcion = '$descripcion', 
                      fecha = '$fecha', 
                      notas = '$notas', 
                      fecha_actualizacion = NOW() 
                  WHERE id = '$id'";
        
        if (!$conexion->query($query)) {
            responder(['error' => 'Error al actualizar la venta: ' . $conexion->error], 500);
        }
        
        if ($conexion->affected_rows === 0) {
            responder(['error' => 'No se encontró la venta o no se realizaron cambios'], 404);
        }
        
        responder(['mensaje' => 'Venta actualizada correctamente']);
    } catch (Exception $e) {
        responder(['error' => 'Error al actualizar la venta: ' . $e->getMessage()], 500);
    }
}

// Eliminar una venta
if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    try {
        // Obtener datos del cuerpo de la solicitud
        $datos = json_decode(file_get_contents('php://input'), true);
        
        if (!$datos || !isset($datos['id'])) {
            responder(['error' => 'ID no proporcionado'], 400);
        }
        
        $id = $conexion->real_escape_string($datos['id']);
        
        // Primero verificar si la venta existe
        $query = "SELECT id FROM ventas WHERE id = '$id'";
        $resultado = $conexion->query($query);
        
        if ($resultado->num_rows === 0) {
            responder(['error' => 'Venta no encontrada'], 404);
        }
        
        // Eliminar la venta
        $query = "DELETE FROM ventas WHERE id = '$id'";
        
        if (!$conexion->query($query)) {
            responder(['error' => 'Error al eliminar la venta: ' . $conexion->error], 500);
        }
        
        responder(['mensaje' => 'Venta eliminada correctamente']);
    } catch (Exception $e) {
        responder(['error' => 'Error al eliminar la venta: ' . $e->getMessage()], 500);
    }
}

// Si llegamos aquí, el método no está soportado
responder(['error' => 'Método no soportado'], 405);
?>
