<?php
require_once 'config.php';

// Obtener todos los recordatorios
if ($_SERVER['REQUEST_METHOD'] === 'GET' && !isset($_GET['id']) && !isset($_GET['cliente_id'])) {
    try {
        $query = "SELECT r.*, c.nombre as nombre_cliente 
                  FROM recordatorios r 
                  JOIN clientes c ON r.cliente_id = c.id 
                  ORDER BY r.fecha_recordatorio ASC";
        $resultado = $conexion->query($query);
        
        if (!$resultado) {
            responder(['error' => 'Error al obtener los recordatorios: ' . $conexion->error], 500);
        }
        
        $recordatorios = [];
        while ($fila = $resultado->fetch_assoc()) {
            $recordatorios[] = $fila;
        }
        
        responder($recordatorios);
    } catch (Exception $e) {
        responder(['error' => 'Error al obtener los recordatorios: ' . $e->getMessage()], 500);
    }
}

// Obtener un recordatorio específico
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['id'])) {
    try {
        $id = $conexion->real_escape_string($_GET['id']);
        $query = "SELECT r.*, c.nombre as nombre_cliente 
                  FROM recordatorios r 
                  JOIN clientes c ON r.cliente_id = c.id 
                  WHERE r.id = '$id'";
        $resultado = $conexion->query($query);
        
        if (!$resultado) {
            responder(['error' => 'Error al obtener el recordatorio: ' . $conexion->error], 500);
        }
        
        $recordatorio = $resultado->fetch_assoc();
        
        if (!$recordatorio) {
            responder(['error' => 'Recordatorio no encontrado'], 404);
        }
        
        responder($recordatorio);
    } catch (Exception $e) {
        responder(['error' => 'Error al obtener el recordatorio: ' . $e->getMessage()], 500);
    }
}

// Obtener recordatorios de un cliente específico
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['cliente_id'])) {
    try {
        $cliente_id = $conexion->real_escape_string($_GET['cliente_id']);
        $query = "SELECT * FROM recordatorios WHERE cliente_id = '$cliente_id' ORDER BY fecha_recordatorio ASC";
        $resultado = $conexion->query($query);
        
        if (!$resultado) {
            responder(['error' => 'Error al obtener los recordatorios del cliente: ' . $conexion->error], 500);
        }
        
        $recordatorios = [];
        while ($fila = $resultado->fetch_assoc()) {
            $recordatorios[] = $fila;
        }
        
        responder($recordatorios);
    } catch (Exception $e) {
        responder(['error' => 'Error al obtener los recordatorios del cliente: ' . $e->getMessage()], 500);
    }
}

// Crear un nuevo recordatorio
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Obtener datos del cuerpo de la solicitud
        $datos = json_decode(file_get_contents('php://input'), true);
        
        if (!$datos) {
            responder(['error' => 'Datos inválidos'], 400);
        }
        
        // Validar datos requeridos
        if (empty($datos['cliente_id']) || empty($datos['titulo']) || empty($datos['fecha_recordatorio'])) {
            responder(['error' => 'El cliente, título y fecha son obligatorios'], 400);
        }
        
        // Preparar consulta
        $cliente_id = $conexion->real_escape_string($datos['cliente_id']);
        $titulo = $conexion->real_escape_string($datos['titulo']);
        $descripcion = $conexion->real_escape_string($datos['descripcion'] ?? '');
        $fecha_recordatorio = $conexion->real_escape_string($datos['fecha_recordatorio']);
        $frecuencia = $conexion->real_escape_string($datos['frecuencia'] ?? 'unica');
        $estado = $conexion->real_escape_string($datos['estado'] ?? 'pendiente');
        
        $query = "INSERT INTO recordatorios (cliente_id, titulo, descripcion, fecha_recordatorio, frecuencia, estado, fecha_registro) 
                  VALUES ('$cliente_id', '$titulo', '$descripcion', '$fecha_recordatorio', '$frecuencia', '$estado', NOW())";
        
        if (!$conexion->query($query)) {
            responder(['error' => 'Error al crear el recordatorio: ' . $conexion->error], 500);
        }
        
        // Registrar interacción
        $recordatorio_id = $conexion->insert_id;
        $tipo = 'recordatorio';
        $query_interaccion = "INSERT INTO interacciones (cliente_id, tipo, descripcion, fecha) 
                              VALUES ('$cliente_id', '$tipo', 'Nuevo recordatorio: $titulo', NOW())";
        $conexion->query($query_interaccion);
        
        responder([
            'id' => $recordatorio_id,
            'mensaje' => 'Recordatorio creado correctamente'
        ], 201);
    } catch (Exception $e) {
        responder(['error' => 'Error al crear el recordatorio: ' . $e->getMessage()], 500);
    }
}

// Actualizar un recordatorio
if ($_SERVER['REQUEST_METHOD'] === 'PUT') {
    try {
        // Obtener datos del cuerpo de la solicitud
        $datos = json_decode(file_get_contents('php://input'), true);
        
        if (!$datos || !isset($datos['id'])) {
            responder(['error' => 'Datos inválidos o ID no proporcionado'], 400);
        }
        
        // Validar datos requeridos
        if (empty($datos['cliente_id']) || empty($datos['titulo']) || empty($datos['fecha_recordatorio'])) {
            responder(['error' => 'El cliente, título y fecha son obligatorios'], 400);
        }
        
        // Preparar consulta
        $id = $conexion->real_escape_string($datos['id']);
        $cliente_id = $conexion->real_escape_string($datos['cliente_id']);
        $titulo = $conexion->real_escape_string($datos['titulo']);
        $descripcion = $conexion->real_escape_string($datos['descripcion'] ?? '');
        $fecha_recordatorio = $conexion->real_escape_string($datos['fecha_recordatorio']);
        $frecuencia = $conexion->real_escape_string($datos['frecuencia'] ?? 'unica');
        $estado = $conexion->real_escape_string($datos['estado'] ?? 'pendiente');
        
        $query = "UPDATE recordatorios 
                  SET cliente_id = '$cliente_id', 
                      titulo = '$titulo', 
                      descripcion = '$descripcion', 
                      fecha_recordatorio = '$fecha_recordatorio', 
                      frecuencia = '$frecuencia', 
                      estado = '$estado', 
                      fecha_actualizacion = NOW() 
                  WHERE id = '$id'";
        
        if (!$conexion->query($query)) {
            responder(['error' => 'Error al actualizar el recordatorio: ' . $conexion->error], 500);
        }
        
        if ($conexion->affected_rows === 0) {
            responder(['error' => 'No se encontró el recordatorio o no se realizaron cambios'], 404);
        }
        
        responder(['mensaje' => 'Recordatorio actualizado correctamente']);
    } catch (Exception $e) {
        responder(['error' => 'Error al actualizar el recordatorio: ' . $e->getMessage()], 500);
    }
}

// Eliminar un recordatorio
if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    try {
        // Obtener datos del cuerpo de la solicitud
        $datos = json_decode(file_get_contents('php://input'), true);
        
        if (!$datos || !isset($datos['id'])) {
            responder(['error' => 'ID no proporcionado'], 400);
        }
        
        $id = $conexion->real_escape_string($datos['id']);
        
        // Primero verificar si el recordatorio existe
        $query = "SELECT id FROM recordatorios WHERE id = '$id'";
        $resultado = $conexion->query($query);
        
        if ($resultado->num_rows === 0) {
            responder(['error' => 'Recordatorio no encontrado'], 404);
        }
        
        // Eliminar el recordatorio
        $query = "DELETE FROM recordatorios WHERE id = '$id'";
        
        if (!$conexion->query($query)) {
            responder(['error' => 'Error al eliminar el recordatorio: ' . $conexion->error], 500);
        }
        
        responder(['mensaje' => 'Recordatorio eliminado correctamente']);
    } catch (Exception $e) {
        responder(['error' => 'Error al eliminar el recordatorio: ' . $e->getMessage()], 500);
    }
}

// Si llegamos aquí, el método no está soportado
responder(['error' => 'Método no soportado'], 405);
?>
